#include "calc.h"
#include <math.h>
#include <string.h>
#include <stdlib.h>

double dConvertRedToDeg =  3.14159265358979323846 / 180;

TCalc::TCalc()
{
	m_iLength = 0;
	m_strValue = 0;
	m_dX = 0;
}


TCalc::~TCalc()
{
	if (m_strValue != 0)
		delete m_strValue;
	CleanGraphPath();
}

/*!
*  Remove all item in graph path
*  \see CountGraphPath()
*  \see Calc(double &aResult)
*/
void TCalc::CleanGraphPath()
{
	QMutexLocker locker(&mutex);

	DoCleanGraphPath();
}
/*!
*  Remove all item in graph path
*  \see CountGraphPath()
*  \see Calc(double &aResult)
*/
void TCalc::DoCleanGraphPath()
{

	for(unsigned int iLoop=0; iLoop < m_VectorList.size(); iLoop++)
    	delete m_VectorList[iLoop]; // free memory
	m_VectorList.clear(); // Deletes all elements from the vector.
}

/*!
*  Error value
*  \return Error value if value is 0 then no error 
*  \see Calc(double &aResult)
*/
int TCalc::iErrorNr()
{
	return m_ErrorNr;	
}

/*!
*  Change the Variable X in formula for the function Calc
*  \param X is a number variable in formula. 
*  \see Calc(double &aResult)
*/
void TCalc::setX(double X)
{
     m_dX = X;
}

/*!
*  Change the formula for the function Calc
*  \param strValue is the formula. 
*  \see Calc(double &aResult)
*/
void TCalc::setFormula(char *strValue)
{
	QMutexLocker locker(&mutex);

	char* temp =  strValue;
	
	int iLen = strlen(temp);
	m_strValue = new char[iLen+1];
	int iIndex = 0;
	for (int iLoop=0; iLoop <= iLen; iLoop++)
	{
		if (temp[iLoop] != ' ')
		{
			if ((temp[iLoop] >= 'a') && (temp[iLoop] <= 'z'))
				m_strValue[iIndex] = temp[iLoop] + ('A'-'a');
			else if (temp[iLoop] == ',')
				m_strValue[iIndex] = '.';
			else
				m_strValue[iIndex] = temp[iLoop];
			iIndex++;
		}
	}
	m_iLength = iIndex-1;
}

/*!
*  fucntion who clac the formula with the X
*  \param aResult answer form the formula
*  \return If Calc could calc the formula. If it was false then Error numeber is in function  iErrorNr 
*  \see iErrorNr()
*  \see setFormula(char *strValue)
*  \see setX(double X)
*/
bool TCalc::Calc(double &aResult)
{
	QMutexLocker locker(&mutex);

	m_iPos = 0;
	m_VariableX = m_dX;
	m_ErrorNr = 0;
	aResult = F();
	return (m_iPos == m_iLength) && (m_ErrorNr == 0);
}

/*!
*  This function return size of point list
*  \return size of point list
*  \see GetGraphPath_Point(int iIndex)
*  \see MakeGraphPath(double dMinX, double dMaxX, double dMinY, double dMaxY, double dMinScale)
*/
int TCalc::CountGraphPath()
{
	QMutexLocker locker(&mutex);
	
	return m_VectorList.size();
}

/*!
*  This function return point of graph path
*  \param iIndex index of graph path
*  \return point
*  \see CountGraphPath()
*  \see MakeGraphPath(double dMinX, double dMaxX, double dMinY, double dMaxY, double dMinScale)
*/
TCalcPoint* TCalc::GetGraphPath_Point(int iIndex)
{
	QMutexLocker locker(&mutex);
	
	return m_VectorList.at(iIndex);
}


void TCalc::InsertPoint(pTCalcPoint &LastPoint1, pTCalcPoint &LastPoint2, bool &bLastOK, double dLastOK_X, double dLastOK_Y)
{
    LastPoint1 = 0;
    if (LastPoint2 != 0 ) 
    {
      if ( bLastOK )
      {
        LastPoint2->dX = dLastOK_X;
        LastPoint2->dY = dLastOK_Y;
      }
      m_VectorList.push_back(LastPoint2);
      LastPoint2 = 0;
    }
    bLastOK = false;
}

/*!
*  This function calc a graph path
*  \param dMinX min Value of X
*  \param dMaxX max Value of X
*  \param dMinY min Value of Y
*  \param dMaxY max Value of Y
*  \param dMinScale increase of X
*  \see CountGraphPath()
*  \see GetGraphPath_Point(int iIndex)
*  \see setFormula(char *strValue)
*  \see setX(double X)
*  \see DistanceToGraphPath(double Point_X, double Point_Y, double &dToGraphX, double &dToGraphY)
*/
void TCalc::MakeGraphPath(double dMinX, double dMaxX, double /*dMinY*/, double /*dMaxY*/, double dMinScale)
{
	QMutexLocker locker(&mutex);

	TCalcPoint* LastPoint1;
	TCalcPoint* LastPoint2;
	double dCalc;
	bool bErrorInCalc, bLastOK;
	double dLastOK_X, dLastOK_Y;
	dLastOK_X = dLastOK_Y = 0;
	DoCleanGraphPath();
	LastPoint1 = 0;
	LastPoint2 = 0;
	bLastOK = false;
	m_VariableX = dMinX;
	dMaxX = dMaxX + dMinScale;
	while (m_VariableX < dMaxX) 
	{
		m_iPos = 0;
		try
		{
			bErrorInCalc = false;
			dCalc = F();
			bErrorInCalc = !((m_iPos == m_iLength) && (m_ErrorNr == 0));

		}
		catch(...)
		{
			bErrorInCalc = true;
			dCalc = 0;
		}
		
		if ( bErrorInCalc ) 
		{
			InsertPoint(LastPoint1, LastPoint2, bLastOK, dLastOK_X, dLastOK_Y);
		}
		else
		{
			if (LastPoint1 == 0) 
			{
				LastPoint1 = new TCalcPoint();
				LastPoint1->dX = m_VariableX;
				LastPoint1->dY = dCalc;
				m_VectorList.push_back(LastPoint1);
			}
			else if ( LastPoint2 == 0)
			{
				LastPoint2 = new TCalcPoint();
				LastPoint2->dX = m_VariableX;
				LastPoint2->dY = dCalc;
			}
			else
			{
				if ( CalcMin(LastPoint1->dX, LastPoint1->dY, LastPoint2->dX, LastPoint2->dY, m_VariableX, dCalc, dMinScale/2) )
				{
					bLastOK = true;
					dLastOK_X = m_VariableX;
					dLastOK_Y = dCalc;
				}
				else
				{
					InsertPoint(LastPoint1, LastPoint2, bLastOK, dLastOK_X, dLastOK_Y);

					LastPoint1 = m_VectorList.at(m_VectorList.size()-1);
				}
      }
    }

    m_VariableX = m_VariableX + dMinScale;
  }
  InsertPoint(LastPoint1, LastPoint2, bLastOK, dLastOK_X, dLastOK_Y);
}

bool TCalc::CalcMin(double LineA_X, double LineA_Y, double LineB_X, double LineB_Y, double Point_X, double Point_Y, double minDiff)
{
	double dLength;
	double dLengthFromLine;
	double dMath;
	double f;
	double e;
	double y;
	double VectorA_X;
	double VectorA_Y;
	bool bResult = false;
	VectorA_X = (LineB_X - LineA_X);
	VectorA_Y = (LineB_Y - LineA_Y);
	dLength = sqrt(VectorA_X * VectorA_X + VectorA_Y * VectorA_Y);

	dMath = VectorA_X * -VectorA_X - VectorA_Y * VectorA_Y;
	if (dMath != 0 )
	{
		e = Point_X - LineA_X;
		f = Point_Y - LineA_Y;

		y = (VectorA_X*f - VectorA_Y*e) / dMath;

		dLengthFromLine = fabs(y * dLength);

		bResult = dLengthFromLine < minDiff;
	}
	return bResult;
}

/*!
*  This function calc distance from point to graph path 
*  \param Point_X Point pos X
*  \param Point_Y Point pos Y
*  \param dToGraphX X value of vector from point to graph path
*  \param dToGraphY Y vakye of vector from point to graph path
*  \return could calc distance
*  \see MakeGraphPath(double dMinX, double dMaxX, double dMinY, double dMaxY, double dMinScale)
*/
bool TCalc::DistanceToGraphPath(double Point_X, double Point_Y, double &dToGraphX, double &dToGraphY)
{ 
	QMutexLocker locker(&mutex);
	
	dToGraphX = 0;
	dToGraphY = 0;
	int iLoop;
	double dMinDistance = 0;
	TCalcPoint *LineA;
	TCalcPoint *LineB;
	bool bHasDistance = false;
	double VectorA_X;
	double VectorA_Y;
	double dLength;
	double dLineLength;
	double dLengthFromLine;
	double e;
	double f;
	double x;
	double y;
	double dMath;

	int iSize = m_VectorList.size();

  
	if (iSize > 1) 
	{
		LineA = m_VectorList.at(0);
		for( iLoop=1; iLoop < iSize; iLoop++)
		{
			LineB = m_VectorList.at(iLoop);

			VectorA_X = (LineB->dX - LineA->dX);
			VectorA_Y = (LineB->dY - LineA->dY);
			dLength = sqrt(VectorA_X * VectorA_X + VectorA_Y * VectorA_Y);

			dMath = VectorA_X * -VectorA_X - VectorA_Y * VectorA_Y;
			if (dMath != 0)
			{
				e = Point_X - LineA->dX;
				f = Point_Y - LineA->dY;
				x = (-VectorA_X*e - VectorA_Y*f) / dMath;
				y = (VectorA_X*f - VectorA_Y*e) / dMath;

				if (x < 0) 
				{
					dLengthFromLine = sqrt((LineA->dX - Point_X) * (LineA->dX - Point_X) + (LineA->dY - Point_Y) * (LineA->dY - Point_Y));
					dLineLength = 0;
				}
				else if (x > 1) 
				{
					dLengthFromLine = sqrt((LineB->dX - Point_X) * (LineB->dX - Point_X) + (LineB->dY - Point_Y) * (LineB->dY - Point_Y));
					dLineLength = dLength;
				}
				else
				{
					dLengthFromLine = fabs(y * dLength);
					dLineLength = x * dLength;
				}
				if ((dLengthFromLine < dMinDistance) or (not bHasDistance)) 
				{
					bHasDistance = true;
					dMinDistance = dLengthFromLine;
					dToGraphX = (LineA->dX + VectorA_X * (dLineLength / dLength)) - Point_X;
					dToGraphY = (LineA->dY + VectorA_Y * (dLineLength / dLength)) - Point_Y;
				}
			}

			LineA = LineB;
		}
	}
	LastPoint_X = Point_X;
	LastPoint_Y = Point_Y;
	LastdToGraphX = dToGraphX;
	LastdToGraphY = dToGraphY;
  return  bHasDistance;
}






///////////////////////////////

double TCalc::Tala()
{
	double dResult = 0;
	if (m_ErrorNr == 0)
	{
		int iLoop = m_iPos;
		while ((m_iLength >= iLoop) && (((m_strValue[iLoop] >= '0') && (m_strValue[iLoop] <= '9')) || (m_strValue[iLoop] == '.')))
		{
		   iLoop++;
		}
		int iLength = iLoop-m_iPos;
		if (iLength > 0)
		{
			char* startPos = new char[iLength+1];
			for (int Loop=0; Loop < iLength; Loop++)
			{
				startPos[Loop] = m_strValue[Loop+m_iPos];
			}
			startPos[iLength] = 0;
	
			dResult = atof(startPos);
			m_iPos = iLoop;
		}
		else
			m_ErrorNr=2;
	}
	return dResult;
}

double TCalc::T()
{
double dResult = 0;
if (m_ErrorNr == 0)
{
		if ((m_iPos < m_iLength) && (m_strValue[m_iPos] == '('))
		{
			m_iPos++;
			dResult = F();
			if ((m_iPos < m_iLength) && (m_strValue[m_iPos] == ')'))
				m_iPos++;
			else
				m_ErrorNr = 1;
		} else
		if ((m_iPos+4 < m_iLength) && (m_strValue[m_iPos] == 'S') && (m_strValue[m_iPos+1] == 'I') && (m_strValue[m_iPos+2] == 'N') && (m_strValue[m_iPos+3] == '('))
		{
			m_iPos = m_iPos + 4;
			dResult = sin( F() * dConvertRedToDeg );
			if ((m_iPos < m_iLength) && (m_strValue[m_iPos] == ')'))
				m_iPos++;
			else
				m_ErrorNr = 1;
		} else
		if ((m_iPos+4 < m_iLength) && (m_strValue[m_iPos] == 'C') && (m_strValue[m_iPos+1] == 'O') && (m_strValue[m_iPos+2] == 'S') && (m_strValue[m_iPos+3] == '('))
		{
			m_iPos = m_iPos + 4;
			dResult = cos( F() * dConvertRedToDeg );
			if ((m_iPos < m_iLength) && (m_strValue[m_iPos] == ')'))
				m_iPos++;
			else
				m_ErrorNr = 1;
		} else if ((m_iPos < m_iLength) && (m_strValue[m_iPos] == 'X'))
		{
			m_iPos++;
			dResult = m_VariableX;
		} else
		{
			dResult = Tala();
			if  ((m_iPos < m_iLength) && (m_strValue[m_iPos] == 'X'))
			{
				m_iPos++;
				dResult = dResult * m_VariableX;
			}
		}
	}
	return dResult;
}

double TCalc::R()
{
	double dResult = 0;
	if (m_ErrorNr == 0)
	{
		dResult = T();
		if ((m_iPos < m_iLength) && (m_strValue[m_iPos] == '^'))
		{
			m_iPos++;
			double dPow = T();
			dResult = pow(dResult, dPow);
		}
		else
		if ((m_iPos+1 < m_iLength) && (m_strValue[m_iPos] == '*') && (m_strValue[m_iPos+1] == '*'))
		{
			m_iPos= m_iPos + 2;
			double dPow = T();
			dResult = pow(dResult, dPow);
		}

	}
	return dResult;	
}

double TCalc::M()
{
	double dResult = 0;
	if (m_ErrorNr == 0)
	{
		if ((m_iPos < m_iLength) && (m_strValue[m_iPos] == '-'))
		{
			m_iPos++;
			dResult = -1 * R();
		}
		else
		{
			dResult = R();
		}
	}
	return dResult;
}

double TCalc::L()
{
	double dResult = 0;
	if (m_ErrorNr == 0)
	{
		dResult = M();
		while ((m_iPos < m_iLength) && ((m_strValue[m_iPos] == '*') || (m_strValue[m_iPos] == '/')))
		{
			if (m_strValue[m_iPos] == '*')
			{
				m_iPos++;
				dResult = dResult * M();
			}
			else
			{ // It is the symbol '/'
				m_iPos++;
				dResult = dResult / M();
			}
		}
	}
	return dResult;
}

double TCalc::F()
{
	double dResult = 0;
	
	if (m_ErrorNr == 0)
	{
		dResult = L();
		while ((m_iPos < m_iLength) && ((m_strValue[m_iPos] == '+') || (m_strValue[m_iPos] == '-')))
		{
			if (m_strValue[m_iPos] == '+')
			{
			m_iPos++;
			dResult = dResult + L();
			}
			else
			{ // It is the symbol '-'
			m_iPos++;
			dResult = dResult - L();
			}
		}
	}
	return dResult;
}
