#ifndef CALC_H
#define CALC_H

#include <vector>
#include <QtCore>


/*!  \author Magni Thor Birgisson mthb1@hi.is
*   \brief Points in graph
*
*/

class TCalcPoint
{
public:
     double dX; /**< Pos X */
     double dY; /**< Pos X */
};

typedef TCalcPoint* pTCalcPoint;



/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Calc formula
*   
*	S    ::= F; <BR>
*   F    ::= L { {"+" | "-"} L}*; <BR>
*	L    ::= M { {"*" | "/"} M}*; <BR>
*	M    ::= ["-"] R; <BR>
*	R    ::= T | T "^" T | T "**" T; <BR>
*	T    ::= "(" F ")" | "SIN(" F ")" | "COS(" F ")" | X | Tala | Tala X; <BR>
*	Tala := {"0" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9"}* ["."] {"0" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9"}*; <BR>
*
*/


class TCalc
{
private:
    double m_VariableX; /**< Value of X in formula */
    double m_dX; /**< Value of X in formula */
    char* m_strValue; /**< The formula */
    int m_iPos; /**< Posison of the formula */
    int m_iLength; /**< length of the formula */
    int m_ErrorNr; /**< Error number when Calc. 0 = no error*/
    std::vector<TCalcPoint*> m_VectorList; /**< graph path*/
    QMutex mutex;

private:
	void DoCleanGraphPath();  //!< Remove all point from graph path with no mutex

protected:
    double Tala();
    double T();
    double R();
    double M();
    double L();
    double F();
	
    void InsertPoint(pTCalcPoint &Point1, pTCalcPoint &Point2, bool &bLastOK, double dLastOK_X, double dLastOK_Y);

    bool CalcMin(double LineA_X, double LineA_Y, double LineB_X, double LineB_Y, double Point_X, double Point_Y, double minDiff);
public:
    TCalc();  //!< constructor
    ~TCalc(); //!< destructor
    bool Calc(double& aResult); //!< Calc a formula
    void CleanGraphPath();  //!< Remove all point from graph path
    void MakeGraphPath(double dMinX, double dMaxX, double dMinY, double dMaxY,  double dMinScale);  //!< calc the graph path
    int CountGraphPath();  //!< Size of the graph path
    TCalcPoint* GetGraphPath_Point(int iIndex);  //!< Point in graph path
    bool DistanceToGraphPath(double Point_X, double Point_Y,   double &dToGraphX, double &dToGraphY);  //!< distance from point to graph path
    void setX(double X);  //!< Value X in formula
    void setFormula( char *strValue); //!< the formula
    int  iErrorNr(); //!< Error number fron calc function
public:
	double LastPoint_X;
	double LastPoint_Y;
	double LastdToGraphX;
	double LastdToGraphY;
};

#endif
