#ifndef HAPTICCUSTOM_H
#define HAPTICCUSTOM_H

#include <QtXml>
#include <QtGui>

#include "hapticdevicecustom.h"
#include "hapticsoundcustom.h"


   
/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Widget for Haptic Device config
*
*	This class ...
*/
class widTapDevice : public QWidget
{
     Q_OBJECT
public:
	widTapDevice(QWidget * parent = 0, Qt::WFlags f = 0);
	
	void setDevice( HapticDeviceCustom* aHapticDevice, HapticSoundCustom* aHapticSound );
	void LoadFromXML( QDomDocument &domDocument );
	void SaveToXML( QDomDocument &domDocument );
   
public slots:
	void OnCenterDeviceClick();
	void OnDefaultClick();
	void OnApplyClick();
	void OnChange( double );
private:
	HapticDeviceCustom* m_HapticDevice;
	
	QDoubleSpinBox* m_MultByLengthA;
	QDoubleSpinBox* m_MaxForceA;
	QDoubleSpinBox* m_LengthA;
	QDoubleSpinBox* m_GridGrowA;
	
	QDoubleSpinBox* m_MultByLengthB;
	QDoubleSpinBox* m_MaxForceB;
	QDoubleSpinBox* m_LengthB;
	QDoubleSpinBox* m_GridGrowB;

	QDoubleSpinBox* m_GridOffset;
	QDoubleSpinBox* m_GridSpace;
	QDoubleSpinBox* m_GridHeight;
	QDoubleSpinBox* m_Scale;
	QDoubleSpinBox* m_SlowPath;
	QDoubleSpinBox* m_MarginX;
	QDoubleSpinBox* m_MarginY;

	QCheckBox* m_GridOn;
	QPushButton*   m_CenterDevice;

};

/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Widget for Sound config
*
*	This class ...
*/

class widTapSound : public QWidget
{
     Q_OBJECT
public:
	widTapSound(QWidget * parent = 0, Qt::WFlags f = 0);
	
	void setDevice( HapticDeviceCustom* aHapticDevice, HapticSoundCustom* aHapticSound  );
	void LoadFromXML( QDomDocument &domDocument );
	void SaveToXML( QDomDocument &domDocument );
public slots:
	void OnChange();
	void OnDefaultClick();
	void OnApplyClick();
private:
	HapticDeviceCustom* m_HapticDevice;
	HapticSoundCustom* m_HapticSound;
	QCheckBox* m_GridTickSound;
	QCheckBox* m_GridPitchSound;
	QCheckBox* m_OnPathSound;
	QCheckBox* m_OnVoicePathSound;
};

/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Widget for Log config
*
*	This class ...
*/

class widTapLog : public QWidget
{
     Q_OBJECT
public:
	widTapLog(QWidget * parent = 0, Qt::WFlags f = 0);
	
	void setDevice( HapticDeviceCustom* aHapticDevice, HapticSoundCustom* aHapticSound  );
	void LoadFromXML( QDomDocument &domDocument );
	void SaveToXML( QDomDocument &domDocument );
   
public slots:
	void OnDefaultClick();
	void OnApplyClick();
};



/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief custom window
*
*	This class ...
*/

class frmCustom : public QDialog
{
	Q_OBJECT
public:
	frmCustom(QWidget * parent = 0, Qt::WFlags f = 0);
	~frmCustom();

	void setDevice( HapticDeviceCustom* aHapticDevice, HapticSoundCustom* aHapticSound );
	void LoadFromXML( QDomDocument &domDocument );
	void SaveToXML( QDomDocument &domDocument );
   
public slots:
	void OnDefaultClick();
	void OnApplyClick();

private:
	widTapDevice* m_widTapDevice;
	widTapSound* m_widTapSound;
	widTapLog* m_widTapLog;
	
};

#endif
