#include "frmgraph.h"



widGraphRender::widGraphRender(QWidget * parent, Qt::WFlags f):
QWidget( parent, f )
{
	m_Calc = 0;
	m_dZoom = 1.0;
	
}

void widGraphRender::setDevice( HapticDeviceCustom* aHapticDevice )
{
	m_HapticDevice = aHapticDevice;
	repaint();
}

void widGraphRender::setZoom( double dZoom )
{
	m_dZoom = dZoom;
	repaint();
}

void widGraphRender::paintEvent(QPaintEvent *)
{
	if ((m_HapticDevice != 0) && (m_Calc != 0))
	{
		double dZoom = m_dZoom * 30;

		QPainter painter(this);
		QRect WindowRect = painter.window();
		int iHeight = WindowRect.height();
		int iWidth = WindowRect.width();
		int CenterX = iWidth / 2;
		int CenterY = iHeight / 2;

		painter.setPen(Qt::blue);

		painter.drawLine( 0, CenterY, iWidth , CenterY);
		painter.drawLine( CenterX, 0, CenterX, iHeight );
		
		painter.setPen(Qt::gray);

		int GridSpace =  (int)m_HapticDevice->getGridSpace();
	
		for (int iLoop=GridSpace; iLoop < iWidth / 2; iLoop = iLoop + GridSpace)
		{
			painter.drawLine( (int)(iLoop*dZoom) + CenterX, 0, 
				(int)(iLoop*dZoom) + CenterX, iHeight);
			painter.drawLine( (int)(-iLoop*dZoom) + CenterX, 0, 
				(int)(-iLoop*dZoom) + CenterX, iHeight);
		}

		for (int iLoop=GridSpace; iLoop < iHeight / 2; iLoop = iLoop + GridSpace)
		{
			painter.drawLine( 0, CenterY - (int)(iLoop*dZoom), 
				iWidth, CenterY - (int)(iLoop*dZoom));
			painter.drawLine( 0, CenterY - (int)(-iLoop*dZoom), 
				iWidth, CenterY - (int)(-iLoop*dZoom));
		}


		painter.setPen(Qt::black);
		//painter.setBrush(brush);
		TCalcPoint *Point1;
		TCalcPoint *Point2;
 //Draw Path
		for (int iLoop=0; iLoop < m_Calc->CountGraphPath()-1; iLoop++)
		{
			Point1 = m_Calc->GetGraphPath_Point(iLoop);
			Point2 = m_Calc->GetGraphPath_Point(iLoop+1);
			painter.drawLine( (int)(Point1->dX*dZoom) + CenterX, CenterY - (int)(Point1->dY*dZoom), 
				(int)(Point2->dX*dZoom) + CenterX, CenterY - (int)(Point2->dY*dZoom));
		}
//Where are you now?
		painter.setPen(Qt::red);
		painter.drawArc( 	
			(int)(m_Calc->LastPoint_X*dZoom) + CenterX - 5,
			CenterY - (int)(m_Calc->LastPoint_Y*dZoom) - 5,
			10, 10, 0, 5760);
		painter.drawLine( (int)(m_Calc->LastPoint_X*dZoom) + CenterX, CenterY - (int)(m_Calc->LastPoint_Y*dZoom), 
				(int)((m_Calc->LastPoint_X + m_Calc->LastdToGraphX)*dZoom) + CenterX, CenterY - (int)((m_Calc->LastPoint_Y + m_Calc->LastdToGraphY)*dZoom));
	}
}

void widGraphRender::setCalc(TCalc* aCalc)
{
	m_Calc = aCalc;
}



/////////////////////////////

frmGraph::frmGraph(QWidget * parent, Qt::WFlags f):
QDialog( parent, f )
{
	resize( 600, 600 );

	
	QVBoxLayout *Layout = new QVBoxLayout(this);

	cmbZoom = new QComboBox(this); 
	connect( cmbZoom, SIGNAL( currentIndexChanged(int) ), SLOT( onZoomChanged(int) ) );
//	connect( Button, SIGNAL( pressed() ), SLOT(OnCalcClick()));	

	Graph = new widGraphRender(this);
	Layout->addWidget(cmbZoom);
	Layout->addWidget(Graph);
	
	cmbZoom->addItem( tr("10%") , 0.1 );
	cmbZoom->addItem( tr("50%") , 0.5 );
	cmbZoom->addItem( tr("100%"), 1.0 );
	cmbZoom->addItem( tr("150%"), 1.5 );
	cmbZoom->addItem( tr("200%"), 2.0 );
	cmbZoom->addItem( tr("250%"), 2.5 );
	cmbZoom->addItem( tr("300%"), 3.0 );
	cmbZoom->setCurrentIndex( cmbZoom->findText( tr("50%") ) );
	
	setWindowTitle(tr("Haptic Graph"));
}

void frmGraph::onZoomChanged(int index)
{
	QVariant var = cmbZoom->itemData( index );
	
	Graph->setZoom( var.toDouble() );
}

void frmGraph::setCalc(TCalc* aCalc)
{
	Graph->setCalc( aCalc );
}


void frmGraph::setDevice( HapticDeviceCustom* aHapticDevice )
{
	Graph->setDevice( aHapticDevice );
}

 


