#ifndef HAPTICGRAPH_H
#define HAPTICGRAPH_H

#include <QtGui>

#include "calc.h"
#include "hapticdevicecustom.h"

/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Widget for Sound config
*
*	This class ...
*/
class widGraphRender : public QWidget
{
	Q_OBJECT
private:
	TCalc* m_Calc;
	HapticDeviceCustom* m_HapticDevice;
	double m_dZoom;
	void paintEvent(QPaintEvent *); 
public:
	widGraphRender(QWidget * parent = 0, Qt::WFlags f = 0);
	
	void setCalc(TCalc* aCalc);  //< Instance of Calc, to show graph
	void setDevice( HapticDeviceCustom* aHapticDevice );
	void setZoom(double dZoom);
};

/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Dialog class to see the graph
*
*	This Dialog show graph
*/
class frmGraph : public QDialog
{
	Q_OBJECT
private:
	widGraphRender* Graph;
	QComboBox* cmbZoom;
public slots:
	void onZoomChanged( int index );
public:
	frmGraph(QWidget * parent = 0, Qt::WFlags f = 0);
	
	void setCalc(TCalc* aCalc);  //< Instance of Calc, to show graph
	void setDevice( HapticDeviceCustom* aHapticDevice );
};

#endif
