

#ifndef HAPTIC_H
#define HAPTIC_H

#include <QtXml>
#include <QtGui>

#include "frmstatus.h"
#include "hapticdevice.h"
#include "hapticsound.h"
#include "frmgraph.h"
#include "frmcustom.h"
#include "calc.h"



/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief main window
*
*	This class ...
*/


class frmMainWindow: public QMainWindow
{
	Q_OBJECT
public:
	frmMainWindow();
	~frmMainWindow();
public:
protected:
	void closeEvent( QCloseEvent* );
	void hideEvent( QHideEvent * );
	void LoadXML();
	
	frmStatus* m_frmStatus;
	frmGraph* m_frmGraph;
	frmCustom* m_frmCustom;

	HapticDeviceCustom* m_HapticDevice;
	HapticSoundCustom* m_HapticSound;
	TCalc* m_Calc;
	
	int m_iTimeCount;
	
private slots:
	void ItemClickAbout();
	void toggle_HapticStatus();
	void toggle_HapticGraph();
	void toggle_HapticCustom();
	void updateWindowMenu();
	void OnCalcClick();
	void OnLogBeginClick();
	void OnLogTouchClick();
	void OnLogEndClick();
	void OnTimeTicked();
private:
	QAction* m_MenuStatus;
	QAction* m_MenuGraph;
	QAction* m_MenuCustom;
	QAction* m_ItemAbout;
	QTimer* m_Timer;
	QLineEdit* m_ledFormula;
	QLineEdit* m_LogTag;
	
	

};


#endif
