#include "hapticdevice.h"

#include <HD/hd.h>
#include <HDU/hduVector.h>
#include <HDU/hduError.h>


	static HapticDeviceData gServoDeviceData;	


	TCalc* Calc;
	HapticSoundCustom* aHapticSound;

	double dOffestHaptic[3] = {0, 0, 0};
	double dMultByLength[2] = {0, 0};
	double dMaxForce[2] = {0, 0};
	double dLength[2] = {0, 0};
	double dGridGrow[2] =  {0, 0};
	double dGridOffset = 0;
	double dScale = 1;
	double dGridHeight = 0;
	double dGridSpace = 10;
	double dSlowPath = 0;
	double dMarginX = 100;
	double dMarginY = 100;
	bool bGridEnabled = true;
	bool bCenterTheDeivce = false;

	double dLastPath[2] = {0, 0};
	double dLastSlowPath[2] = {0, 0};

	hduVector3Dd pos;

	int iState = 1;





HDCallbackCode HDCALLBACK updateDeviceCallback(void *)
{

    int nButtons = 0;


    hdBeginFrame(hdGetCurrentDevice());

    /* Retrieve the current button(s). */
    hdGetIntegerv(HD_CURRENT_BUTTONS, &nButtons);

    /* In order to get the specific button 1 state, we use a bitmask to
       test for the HD_DEVICE_BUTTON_1 bit. */
    gServoDeviceData.m_buttonState =
        (nButtons & HD_DEVICE_BUTTON_1) ? true : false;

    /* Get the current location of the device (HD_GET_CURRENT_POSITION)
       We declare a vector of three doubles since hdGetDoublev returns
       the information in a vector of size 3. */
    hdGetDoublev(HD_CURRENT_POSITION, pos);

  //  hdGetString(HD_DEVICE_VENDOR, gServoDeviceData.m_vendor);
//    hdGetDoublev(HD_CURRENT_VELOCITY, gServoDeviceData.m_velocity);
//    hdGetDoublev(HD_CURRENT_TRANSFORM, gServoDeviceData.m_transform);

	dLastPath[0] = gServoDeviceData.m_path[0];
	dLastPath[1] = gServoDeviceData.m_path[1];

	gServoDeviceData.m_path[0]=0;
	gServoDeviceData.m_path[1]=0;
	gServoDeviceData.m_grid[0]=0;
	gServoDeviceData.m_grid[1]=0;
	
	if (bCenterTheDeivce)
	{
		dOffestHaptic[0] = -1 * pos[0] * dScale;
		dOffestHaptic[1] = -1 * pos[1] * dScale;
		dOffestHaptic[2] = -1 * pos[2] * dScale;
		bCenterTheDeivce = false;
	}
	
	gServoDeviceData.m_devicePosition[0] = pos[0] = pos[0] * dScale + dOffestHaptic[0];
	gServoDeviceData.m_devicePosition[1] = pos[1] = pos[1] * dScale + dOffestHaptic[1];
	gServoDeviceData.m_devicePosition[2] = pos[2] = pos[2] * dScale + dOffestHaptic[2];
	
	
	gServoDeviceData.m_force[0] = 0;
	gServoDeviceData.m_force[1] = 0;
	gServoDeviceData.m_force[2] = 0;


	double Point_X, Point_Y, dToGraphX, dToGraphY;
	Point_X = pos[0];
	Point_Y = pos[1];
	if (Calc->DistanceToGraphPath(Point_X, Point_Y, dToGraphX, dToGraphY))
	{

		gServoDeviceData.m_path[0]=Point_X+dToGraphX;
		gServoDeviceData.m_path[1]=Point_Y+dToGraphY;

		double dSlowPathX = (dLastPath[0] - gServoDeviceData.m_path[0]) * dSlowPath + dLastSlowPath[0]*0.8;
		double dSlowPathY = (dLastPath[1] - gServoDeviceData.m_path[1]) * dSlowPath + dLastSlowPath[0]*0.8;
		dLastSlowPath[0] = dSlowPathX;
		dLastSlowPath[1] = dSlowPathY;

		double dGridForce;
		dGridForce = pos[2] * -1;


		if (bGridEnabled)
		{
			if (fabs((int)(gServoDeviceData.m_path[0]/dGridSpace) - (gServoDeviceData.m_path[0]/dGridSpace)) < dGridOffset)
			{ 
				if (fabs((int)(gServoDeviceData.m_path[0]/dGridSpace)) == 0)
					dGridForce = (dGridForce + dGridHeight*2*fabs((int)(gServoDeviceData.m_path[0]/dGridSpace) - (gServoDeviceData.m_path[0]/dGridSpace)));
				else
					dGridForce = (dGridForce + dGridHeight*fabs((int)(gServoDeviceData.m_path[0]/dGridSpace) - (gServoDeviceData.m_path[0]/dGridSpace)));
				gServoDeviceData.m_grid[0]=1;
	
			}
	
			if (fabs((int)(gServoDeviceData.m_path[1]/dGridSpace) - (gServoDeviceData.m_path[1]/dGridSpace)) < dGridOffset)
			{
				if (fabs((int)(gServoDeviceData.m_path[1]/dGridSpace)) == 0)
					dGridForce = (dGridForce + dGridHeight*2*fabs((int)(gServoDeviceData.m_path[1]/dGridSpace) - (gServoDeviceData.m_path[1]/dGridSpace)));
				else
					dGridForce = (dGridForce + dGridHeight*fabs((int)(gServoDeviceData.m_path[1]/dGridSpace) - (gServoDeviceData.m_path[1]/dGridSpace)));
				gServoDeviceData.m_grid[1]=1;
	
			}
		}

		hduVector3Dd forceDirection( dToGraphX + dSlowPathX, dToGraphY + dSlowPathY, dGridForce);
		
		double dLengthForce =  sqrt(forceDirection[0]*forceDirection[0] + forceDirection[1]*forceDirection[1] + forceDirection[2]*forceDirection[2]);

		if ((iState == 0) && (dLengthForce > dLength[0]))
			iState = 1;
		else if ((iState == 1) && (dLengthForce < dLength[1]))
			iState = 0;


		forceDirection[0] = forceDirection[0] * dMultByLength[iState];
		forceDirection[1] = forceDirection[1] * dMultByLength[iState];
		forceDirection[2] = forceDirection[2] * dGridGrow[iState];

		//out of margin
		if (pos[0] > dMarginX)
			forceDirection[0] += (dMarginX-pos[0])*dMultByLength[0];
		else if (pos[0] < -dMarginX)
			forceDirection[0] += (-dMarginX-pos[0])*dMultByLength[0];

		if (pos[1] > dMarginY)
			forceDirection[1] += (dMarginY-pos[1])*dMultByLength[0];
		else if (pos[1] < -dMarginY)
			forceDirection[1] += (-dMarginY-pos[1])*dMultByLength[0];

		
		dLengthForce =  sqrt(forceDirection[0]*forceDirection[0] + 
			forceDirection[1]*forceDirection[1] + 
			forceDirection[2]*forceDirection[2]);


		if (dMaxForce[iState] > 0)
		{
			if ( (dLengthForce > dMaxForce[iState]) && (dLengthForce > 0) )
			{
				forceDirection[0] = (forceDirection[0] / dLengthForce) * dMaxForce[iState];
				forceDirection[1] = (forceDirection[1] / dLengthForce) * dMaxForce[iState];
				forceDirection[2] = (forceDirection[2] / dLengthForce) * dMaxForce[iState];
	
			}
	
			hdSetDoublev(HD_CURRENT_FORCE, forceDirection);
			gServoDeviceData.m_force[0] = forceDirection[0];
			gServoDeviceData.m_force[1] = forceDirection[1];
			gServoDeviceData.m_force[2] = forceDirection[2];
		}

		
	}
	gServoDeviceData.m_iState = iState;
    //hdGetDoublev(HD_CURRENT_FORCE, gServoDeviceData.m_force);


    hdEndFrame(hdGetCurrentDevice());

    // In case of error, terminate the callback.
    HDErrorInfo error;
    if (HD_DEVICE_ERROR(error = hdGetError()))
    {
        hduPrintError(stderr, &error, "Error detected during main scheduler callback\n");

        if (hduIsSchedulerError(&error))
        {
            return HD_CALLBACK_DONE;
        }
    }

	aHapticSound->UpdateData( &gServoDeviceData );


    return HD_CALLBACK_CONTINUE;
}

HDCallbackCode HDCALLBACK copyDeviceDataCallback(void *pUserData)
{
    HapticDeviceData *pDeviceData = (HapticDeviceData *) pUserData;

    memcpy(pDeviceData, &gServoDeviceData, sizeof(HapticDeviceData));

    return HD_CALLBACK_DONE;
}


void HapticDevice::UpdateData()
{
        hdScheduleSynchronous(copyDeviceDataCallback,
                              currentHapticDeviceData,
                              HD_MIN_SCHEDULER_PRIORITY);
}


HapticDevice::HapticDevice(TCalc* aCalc, HapticSoundCustom* aHapticSoundCustom):HapticDeviceCustom()
{
	Calc = aCalc;
	aHapticSound = aHapticSoundCustom;



    hUpdateHandle = 0;
    HDErrorInfo error;

    /* Initialize the device, must be done before attempting to call any hd
       functions. */
    hHD = hdInitDevice(HD_DEFAULT_DEVICE);
    if (HD_DEVICE_ERROR(error = hdGetError()))
    {
        hduPrintError(stderr, &error, "Failed to initialize the device");
        fprintf(stderr, "\nPress any key to quit.\n");
      //  std::cin.get();
        //return -1;
    }
    hUpdateHandle = hdScheduleAsynchronous(
        updateDeviceCallback, currentHapticDeviceData, HD_MAX_SCHEDULER_PRIORITY);

    /* Start the servo loop scheduler. */
    hdEnable(HD_FORCE_OUTPUT);
    hdStartScheduler();
    if (HD_DEVICE_ERROR(error = hdGetError()))
    {
        hduPrintError(stderr, &error, "Failed to start the scheduler");
        fprintf(stderr, "\nPress any key to quit.\n");
        //std::cin.get();
        //return -1;
    }
}


HapticDevice::~HapticDevice()
{
    hdStopScheduler();
    hdUnschedule(hUpdateHandle);
    hdDisableDevice(hHD);
}



void HapticDevice::setMultByLengthA( double value )
{
	dMultByLength[0] = value;
}

void HapticDevice::setMaxForceA( double value )
{
	dMaxForce[0] = value;
}

void HapticDevice::setLengthA( double value )
{
	dLength[0] = value;
}

void HapticDevice::setGridGrowA( double value )
{
	dGridGrow[0] = value;
}

void HapticDevice::setMultByLengthB( double value )
{
	dMultByLength[1] = value;
}

void HapticDevice::setMaxForceB( double value )
{
	dMaxForce[1] = value;
}

void HapticDevice::setLengthB( double value )
{
	dLength[1] = value;
}

void HapticDevice::setGridGrowB( double value )
{
	dGridGrow[1] = value;
}

void HapticDevice::setGridOffset( double value )
{
	dGridOffset = value;
}

void HapticDevice::setGridSpace( double value )
{
	dGridSpace = value;
}

double HapticDevice::getGridSpace()
{
	return dGridSpace;
}

void HapticDevice::setGridHeight( double value )
{
	dGridHeight = value;
}

void HapticDevice::setScale( double value )
{
	dScale = value;
}

void HapticDevice::setSlowPath( double value)
{
	dSlowPath = value;
}

void HapticDevice::setMarginX( double value)
{
	dMarginX = value;
}

void HapticDevice::setMarginY( double value)
{
	dMarginY = value;
}

void HapticDevice::setOffestHaptic( double value[3] )
{
	dOffestHaptic[0] = value[0];
	dOffestHaptic[1] = value[1];
	dOffestHaptic[2] = value[2];
}

void HapticDevice::CenterDevice()
{
	bCenterTheDeivce = true;
}


double HapticDevice::getScale()
{
	return dScale;
}

void HapticDevice::setGridEnabled( bool value )
{
	bGridEnabled = value;
}

bool HapticDevice::getGridEnabled()
{
	return bGridEnabled;
}

