#ifndef HAPTICDEVICECUSTOM_H
#define HAPTICDEVICECUSTOM_H


/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Data from Haptic deivce
*
*	 Data from Haptic deivce
*/

typedef struct
{

//		HDErrorInfo m_error;           /**< Current Error. */
//		HDstring m_vendor;             /**< vendor. */
//		hduVector3Dd m_velocity;         /**< velocity. */
//		HDdouble m_transform[16];      /**< transform. */

	bool m_buttonState;       /**< Has the device button has been pressed. */
	double m_devicePosition[3]; /**< Current device coordinates. */
	double m_force[3];          /**< Current force. */
	double m_path[2];
	double m_grid[2];
	int m_iState;  /**< Current state. */
} HapticDeviceData;


/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Data from Haptic deivce
*
*	 Data from Haptic deivce
*/



class HapticDeviceCustom
{
private:


public:
	HapticDeviceData *currentHapticDeviceData;

	HapticDeviceCustom();

	virtual ~HapticDeviceCustom();

	virtual void setMultByLengthA( double value ) = 0;
	virtual void setMaxForceA( double value ) = 0;
	virtual void setLengthA( double value ) = 0;
	virtual void setGridGrowA( double value ) = 0;
	virtual void setMultByLengthB( double value ) = 0;
	virtual void setMaxForceB( double value ) = 0;
	virtual void setLengthB( double value ) = 0;
	virtual void setGridGrowB( double value ) = 0;
	virtual void setGridOffset( double value ) = 0;
	virtual void setGridSpace( double value ) = 0;
	virtual void setGridHeight( double value ) = 0;
	virtual void setScale( double value ) = 0;
	virtual void setSlowPath( double value) = 0;
	virtual	void setMarginX( double value ) = 0;
	virtual void setMarginY( double value ) = 0;

	virtual void setGridEnabled( bool value ) = 0; 
	virtual void setOffestHaptic( double value[3] ) = 0;


	virtual double getGridSpace() = 0;
	virtual double getScale() = 0;
	virtual bool getGridEnabled() = 0;

	virtual void UpdateData() = 0;

	virtual void CenterDevice() = 0;

};

#endif
