#include "hapticsound.h"
#include <cstdlib>
#include <QtGui>
#include <math.h>

#define NUM_ENVIRONMENTS 1

ALfloat listenerPos[]={0.0,0.0,4.0};
ALfloat listenerVel[]={0.0,0.0,0.0};
ALfloat	listenerOri[]={0.0,0.0,1.0, 0.0,1.0,0.0};


ALfloat source0Pos[]={ 0.0, 0.0, 0.0};
ALfloat source0Vel[]={ 0.0, 0.0, 0.0};


ALfloat source1Pos[]={ 0.0, 0.0, 0.0};
ALfloat source1Vel[]={ 0.0, 0.0, 0.0};

ALfloat source2Pos[]={ 0.0, 0.0, 0.0};
ALfloat source2Vel[]={ 0.0, 0.0, 0.0};

HapticSound::HapticSound()
{
	m_bGridTickSound = false;
	m_bGridPitchSound = false;
	m_bOnPathSound = false;
	m_bOnVoicePathSound = false;

	m_bText = 0;
	m_iLastState = 1;

	m_alContext = 0;

	alutInit(0, 0);
	alListenerfv(AL_POSITION, listenerPos);
	alListenerfv(AL_VELOCITY, listenerVel);
	alListenerfv(AL_ORIENTATION,listenerOri);
	alGetError(); // clear any error messages
	if(alGetError() != AL_NO_ERROR) 
	{
		//fprintf(stderr, "- Error creating buffers !!\n");
		//exit(1);
	}
    // Generate buffers, or else no sound will happen!
	alGenBuffers(NUM_BUFFERS, buffer);
	alGenBuffers(1, VoiceBuffer);

	buffer[0] = alutCreateBufferFromFile("X.wav");
	buffer[1] = alutCreateBufferFromFile("Y.wav");
	buffer[2] = alutCreateBufferFromFile("OnEnter.wav");
	buffer[3] = alutCreateBufferFromFile("OnExit.wav");
	buffer[4] = alutCreateBufferWaveform (ALUT_WAVEFORM_SINE, 364, 10, 4.1f);

	alGenSources(NUM_SOURCES, source);
	
	if(alGetError() != AL_NO_ERROR) 
	{
		//fprintf(stderr, "- Error creating Source !!\n");
	}
	
	alSourcef(source[0],AL_PITCH, 1.0f);
	alSourcef(source[0],AL_GAIN, 1.0f);
	source0Pos[0] = -4;
	alSourcefv(source[0],AL_POSITION, source0Pos);
	alSourcefv(source[0],AL_VELOCITY, source1Vel);
	alSourcei(source[0],AL_BUFFER, buffer[0]);
	alSourcei(source[0],AL_LOOPING, AL_FALSE);
	
	alSourcef(source[1],AL_PITCH,1.0f);
	alSourcef(source[1],AL_GAIN,1.0f);
	source0Pos[0] = 4;
	alSourcefv(source[1],AL_POSITION,source0Pos);
	alSourcefv(source[1],AL_VELOCITY,source1Vel);
	alSourcei(source[1],AL_BUFFER,buffer[1]);
	alSourcei(source[1],AL_LOOPING,AL_FALSE);
	
	alSourcef(source[2],AL_PITCH,1.0f);
	alSourcef(source[2],AL_GAIN,10.0f);
	alSourcefv(source[2],AL_POSITION,source1Pos);
	alSourcefv(source[2],AL_VELOCITY,source1Vel);
	alSourcei(source[2],AL_BUFFER,buffer[2]);
	alSourcei(source[2],AL_LOOPING, AL_FALSE);

	alSourcef(source[3],AL_PITCH,1.0f);
	alSourcef(source[3],AL_GAIN,10.0f);
	alSourcefv(source[3],AL_POSITION,source1Pos);
	alSourcefv(source[3],AL_VELOCITY,source1Vel);
	alSourcei(source[3],AL_BUFFER,buffer[3]);
	alSourcei(source[3],AL_LOOPING, AL_FALSE);

	alSourcef(source[4],AL_PITCH,1.0f);
	alSourcef(source[4],AL_GAIN,22.0f);
	alSourcefv(source[4],AL_POSITION,source1Pos);
	alSourcefv(source[4],AL_VELOCITY,source1Vel);
	alSourcei(source[4],AL_LOOPING, AL_FALSE);

	alSourcef(source[5],AL_PITCH,1.0f);
	alSourcef(source[5],AL_GAIN,1.0f);
	alSourcefv(source[5],AL_POSITION,source2Pos);
	alSourcefv(source[5],AL_VELOCITY,source2Vel);
	alSourcei(source[5],AL_BUFFER,buffer[4]);
	alSourcei(source[5],AL_LOOPING, AL_TRUE);

}


HapticSound::~HapticSound()
{
	alDeleteBuffers(1, VoiceBuffer);
	alDeleteBuffers(NUM_BUFFERS, buffer);
	alDeleteSources(NUM_SOURCES, source);
	alutExit();
}

void HapticSound::setGridTickSound( bool value )
{
	m_bGridTickSound = value;
}

void HapticSound::setGridPitchSound( bool value )
{
	m_bGridPitchSound = value;
	if (m_bGridPitchSound)
		alSourcePlay(source[5]);
	else
		alSourceStop(source[5]);

}
void HapticSound::setOnPathSound( bool value )
{
	m_bOnPathSound = value;
}

void HapticSound::setOnVoicePathSound( bool value )
{
	m_bOnVoicePathSound = value;
}


void HapticSound::UpdateData(HapticDeviceData* currentHapticDeviceData)
{
	if ( (m_bOnVoicePathSound) && (currentHapticDeviceData->m_buttonState)&&(m_bText == 0))
	{
		m_bText = 2000;
		QString text;
		QString strX, strY;
		double dx = round( (currentHapticDeviceData->m_path[0]) * 10 ) * 0.1;
		double dy = round( (currentHapticDeviceData->m_path[1]) * 10 ) * 0.1;
		if (dx < 0)
			strX.sprintf("minus %g", fabs(dx));
		else
			strX.sprintf("%g", dx);
		if (dy < 0)
			strY.sprintf("minus %g", fabs(dy));
		else
			strY.sprintf("%g", dy);

		text.sprintf("flite -o voice.wav -t \"x= %s and y= %s\"", strX.toAscii().data(), strY.toAscii().data());

		int iResult = system(text.toAscii().data());
		if (iResult == 0)
		{
			alSourceStop(source[4]);

//			alDeleteBuffers(1, VoiceBuffer);
//			alGenBuffers(1, VoiceBuffer);

	alGetError(); // clear any error messages
			
			
			VoiceBuffer[0] = alutCreateBufferFromFile("voice.wav");
			alSourcei(source[4], AL_BUFFER, VoiceBuffer[0]);

			alSourcePlay(source[4]);
		}
		else
			alSourcePlay(source[3]);
	}
	else
	{	
		if ( m_bText > 0)
			m_bText--;
		else
			if ( m_bText != 0)
				m_bText = 0;
	}
	if ( (m_bOnPathSound) && (currentHapticDeviceData->m_iState != m_iLastState))
	{
		if (currentHapticDeviceData->m_iState == 0)
			alSourcePlay(source[2]);
		else
			alSourcePlay(source[3]);
		m_iLastState = currentHapticDeviceData->m_iState;
	}
	if (m_bGridPitchSound)
	{
		source2Pos[0] = currentHapticDeviceData->m_path[0] * -1;
		alSourcefv(source[5], AL_POSITION, source2Pos);
		float dRangePercent = 1 + currentHapticDeviceData->m_path[1]*(0.08);
		alSourcef(source[5], AL_PITCH, dRangePercent);
	}	

	if ( (m_bGridTickSound) && (currentHapticDeviceData->m_iState == 0))
	{	
		if ((currentHapticDeviceData->m_grid[0] != m_LastGrid[0]) )
		{
			if (fabs(currentHapticDeviceData->m_path[0]) < 0.5)
				alSourcef(source[1],AL_GAIN, 2.0f);
			else
				alSourcef(source[1],AL_GAIN, 0.5f);

			m_LastGrid[0] = currentHapticDeviceData->m_grid[0];
			if (m_LastGrid[0] == 1)
				alSourcePlay(source[1]);
		}
		if ((currentHapticDeviceData->m_grid[1] != m_LastGrid[1]) )
		{
			if (fabs(currentHapticDeviceData->m_path[1]) < 0.5)
				alSourcef(source[0],AL_GAIN, 4.0f);
			else
				alSourcef(source[0],AL_GAIN, 1.0f);

			m_LastGrid[1] = currentHapticDeviceData->m_grid[1];
			if (m_LastGrid[1] == 1)
				alSourcePlay(source[0]);
		}
	}

}


