#ifndef HAPTICSOUND_H
#define HAPTICSOUND_H

#include <AL/al.h>
#include <AL/alut.h>
#include "hapticdevicecustom.h"
#include "hapticsoundcustom.h"




/*!  \author Magni Thor Birgisson mthb1@hi.is
*    \brief HapticSound
*
*/

#define NUM_BUFFERS 5
#define NUM_SOURCES 6


class HapticSound: public HapticSoundCustom
{
private:
	ALCcontext *m_alContext;
	ALCdevice  *m_alDevice;
	ALuint	VoiceBuffer[1];
	ALuint	buffer[NUM_BUFFERS];
	ALuint	source[NUM_SOURCES];

	double m_LastGrid[2];
	int m_iLastState;
	int m_bText;
	
	bool m_bGridTickSound;
	bool m_bGridPitchSound;
	bool m_bOnPathSound;
	bool m_bOnVoicePathSound;
public:
	HapticSound();
	
	~HapticSound();

	void UpdateData(HapticDeviceData* currentHapticDeviceData);

	void setGridTickSound( bool value );
	void setGridPitchSound( bool value );
	void setOnPathSound( bool value );
	void setOnVoicePathSound( bool value );

	bool getGridTickSound()    { return m_bGridTickSound;    };
	bool getGridPitchSound()   { return m_bGridPitchSound;   };
	bool getOnPathSound()	   { return m_bOnPathSound;      };
	bool getOnVoicePathSound() { return m_bOnVoicePathSound; };


};

#endif
